# RemoteAHK-Launcher

AutoHotkey-based pull-and-run system:
- Downloads a worker `.ahk` and a `payload.json` from known URLs
- Replaces `{#tag}` placeholders inside the worker using JSON values
- Runs the worker with optional CLI params from JSON
- Worker completes tasks and re-activates the original launcher

> **AHK Version:** AutoHotkey v1.1 (Unicode). Works on Windows 10/11.

## Quick Start

1. Install AutoHotkey v1.1 (Unicode).
2. Clone this repo.
3. Edit **`config/launcher.json`**:
   - `base_url` – folder containing remote workers
   - `worker` – default worker `.ahk` to execute
   - attachment/mail defaults for all workers
4. Put your local configs in `config/`:
   - `smtp.json` – SMTP credentials (DO NOT commit secrets)
5. Run `Launcher.ahk`.

The launcher will:
- Download the worker `.ahk` and its JSON definition
- Merge defaults from `launcher.json` with the worker config
- Replace `{#tag}` placeholders in the worker
- Execute the resolved worker with optional `run_params`

### Local JSON Files

- `config/launcher.json`: base URL and defaults for all workers
- `config/smtp.json`: SMTP credentials for `CDO.Message`

### Example Workers

- **GoogleImageToEmail.ahk**: gets first image URL for a query and emails it.
- **SendFolderFileEmail.ahk**: sends an email with one attachment from a defined folder/file.

### Security Notes
- Never commit real credentials. `smtp.json` is in `.gitignore`.
- For STARTTLS (port 587), we set `smtpusessl=true`; CDO will STARTTLS if the server supports it.

### Troubleshooting
- If email fails: verify host/port/user/pass, and that the server supports STARTTLS/TLS.
- If Google blocks requests: add delay/user-agent or run via browser automation instead.

