; ─────────────────────────────────────────────────────────
; GoogleImageToEmail.ahk
; - Looks up first image URL for a query and emails it
; - Uses smtp.json for SMTP creds
; - Reactivates original launcher on completion
; ─────────────────────────────────────────────────────────
#NoEnv
#Warn
SetBatchLines, -1
SetWorkingDir, %A_ScriptDir%

DEFAULT_JSON := "https://example.com/remote-ahk/default.json"
jsonPath     := A_ScriptDir . "\payload.json"

if !FileExist(jsonPath) {
    URLDownloadToFile2(DEFAULT_JSON, jsonPath)
}
FileRead, jsonText, %jsonPath%

; Values injected by launcher (or fallback)
searchQ := "{#search_query}"
mailTo  := "{#send_to_email}"
if (searchQ = "" || searchQ = "{#search_query}")
    searchQ := "roger rabbit"

cfg := LoadSmtpConfig()
smtpHost := cfg.host
smtpPort := cfg.port
smtpSSL  := (cfg.security ~= "i)(ssl|starttls)") ? "true" : "false"
smtpUser := cfg.user
smtpPass := cfg.pass
mailFrom := cfg.user

; Fetch first image URL
q    := URLEncode(searchQ)
url  := "https://www.google.com/search?tbm=isch&q=" q
html := HttpGet(url)
if (html = "") {
    MsgBox, 16, GoogleImageToEmail, Failed to fetch Google Images.
    ExitApp
}
if RegExMatch(html, "i)https?://[^""]+\.(?:jpg|jpeg|png|webp)", m)
    imgUrl := m
else
    imgUrl := "N/A"

subject := "First image for query: " searchQ
body    := "Search: " searchQ "`r`nImage URL: " imgUrl

ok := SendSMTP(mailFrom, mailTo, "", "", subject, body, "", smtpHost, smtpPort, smtpSSL, smtpUser, smtpPass)
if !ok {
    MsgBox, 16, GoogleImageToEmail, Failed to send email.
}

; Reactivate original
origPath := JsonGet(jsonText, "reactivate_script_path")
origArgs := JsonGet(jsonText, "reactivate_args")
if (origPath != "")
    Run, "%A_AhkPath%" "%origPath%" %origArgs%

ExitApp

; ── Helpers ─────────────────────────────────────────────
URLEncode(s) {
    A_FormatInteger := A_FormatInt
