; ─────────────────────────────────────────────────────────
; SendFolderFileEmail.ahk
; - Sends an email with one attachment (path from JSON)
; - Uses smtp.json creds
; - Reactivates original launcher on completion
; ─────────────────────────────────────────────────────────
#NoEnv
#Warn
SetBatchLines, -1
SetWorkingDir, %A_ScriptDir%

DEFAULT_JSON := "https://example.com/remote-ahk/default.json"
jsonPath     := A_ScriptDir . "\payload.json"

if !FileExist(jsonPath) {
    URLDownloadToFile2(DEFAULT_JSON, jsonPath)
}
FileRead, jsonText, %jsonPath%

folder   := JsonGetDeep(jsonText, "attachment.folder")
fileName := JsonGetDeep(jsonText, "attachment.file_name")
if (folder = "")
    folder := "C:\Temp"
fullPath := folder "\" fileName

to    := "{#mail2.to}"
cc    := "{#mail2.cc}"
bcc   := "{#mail2.bcc}"
subject := "{#mail2.subject}"
; prefer authenticated from
cfg := LoadSmtpConfig()
from := cfg.user

smtpHost := cfg.host
smtpPort := cfg.port
smtpSSL  := (cfg.security ~= "i)(ssl|starttls)") ? "true" : "false"
smtpUser := cfg.user
smtpPass := cfg.pass

if !FileExist(fullPath) {
    MsgBox, 16, SendFolderFileEmail, Attachment not found:`n%fullPath%
    ExitApp
}

body := "Please find attached: " fileName

ok := SendSMTP(from, to, cc, bcc, subject, body, fullPath, smtpHost, smtpPort, smtpSSL, smtpUser, smtpPass)
if !ok {
    MsgBox, 16, SendFolderFileEmail, Failed to send email.
}

origPath := JsonGet(jsonText, "reactivate_script_path")
origArgs := JsonGet(jsonText, "reactivate_args")
if (origPath != "")
    Run, "%A_AhkPath%" "%origPath%" %origArgs%

ExitApp

; ── Helpers ─────────────────────────────────────────────
SendSMTP(from, to, cc, bcc, subject, body, attach, host, port, ssl, user, pass) {
    msg := ComObjCreate("CDO.Message")
    cfg := msg.Configuration.Fields
    cfg.Item("http://schemas.microsoft.com/cdo/configuration/sendusing") := 2
    cfg.Item("http://schemas.microsoft.com/cdo/configuration/smtpserver") := host
    cfg.Item("http://schemas.microsoft.com/cdo/configuration/smtpserverport") := port+0
    cfg.Item("http://schemas.microsoft.com/cdo/configuration/smtpusessl") := (ssl="true")
    if (user != "") {
        cfg.Item("http://schemas.microsoft.com/cdo/configuration/smtpauthenticate") := 1
        cfg.Item("http://schemas.microsoft.com/cdo/configuration/sendusername") := user
        cfg.Item("http://schemas.microsoft.com/cdo/configuration/sendpassword") := pass
    }
    cfg.Update()
    msg.From    := from
    msg.To      := to
    if (cc  != "") msg.CC  := cc
    if (bcc != "") msg.BCC := bcc
    msg.Subject := subject
    msg.TextBody:= body
    if (attach != "" && FileExist(attach))
        msg.AddAttachment(attach)
    try {
        msg.Send()
        return true
    } catch e {
        return false
    }
}

; dotted JSON: a.b
JsonGetDeep(byref j, keyPath) {
    parts := StrSplit(keyPath, ".")
    if (parts.Length() = 1)
        return JsonGetFlat(j, parts[1])
    obj := j
    Loop % parts.Length() - 1 {
        seg := parts[A_Index]
        obj := JsonGetObjectText(obj, seg)
        if (obj = "")
            return ""
    }
    return JsonGetFlat(obj, parts[parts.Length()])
}
JsonGet(byref j, key) {
    pat := """" key """\s*:\s*""([^""]*)"""
    if RegExMatch(j, pat, m)
        return m1
    return ""
}
JsonGetFlat(byref jt, key) {
    pat := """" key """\s*:\s*""([^""]*)"""
    if RegExMatch(jt, pat, m)
        return m1
    return ""
}
JsonGetObjectText(byref jt, key) {
    pat := """" key """\s*:\s*\{"
    if !RegExMatch(jt, pat, m, pos)
        return ""
    start := m.Pos(0) + m.Len(0) - 1
    depth := 1, i := start+1
    while (i <= StrLen(jt)) {
        ch := SubStr(jt, i, 1)
        if (ch = "{") depth++
        else if (ch = "}") {
            depth--
            if (depth = 0)
                return "{" . SubStr(jt, start+1, i-start-1) . "}"
        }
        i++
    }
    return ""
}
URLDownloadToFile2(url, outPath) {
    whr := ComObjCreate("WinHttp.WinHttpRequest.5.1")
    try {
        whr.Open("GET", url, false), whr.Send()
        if (whr.Status != 200)
            return false
        ado := ComObjCreate("ADODB.Stream")
        ado.Type := 1, ado.Open(), ado.Write(whr.ResponseBody), ado.SaveToFile(outPath, 2), ado.Close()
        return true
    } catch e {
        return false
    }
}
LoadSmtpConfig() {
    local p := A_ScriptDir . "\smtp.json"
    cfg := {host:"",port:"",security:"",user:"",pass:""}
    if FileExist(A_ScriptDir . "\..\config\smtp.json")
        p := A_ScriptDir . "\..\config\smtp.json"
    if !FileExist(p) {
        MsgBox, 16, Worker, smtp.json not found.`n%p%
        return cfg
    }
    FileRead, txt, %p%
    cfg.host     := JsonGet(txt, "smtp_server")
    cfg.port     := JsonGet(txt, "smtp_port")
    cfg.security := JsonGet(txt, "smtp_security")
    cfg.user     := JsonGet(txt, "smtp_user")
    cfg.pass     := JsonGet(txt, "smtp_password")
    return cfg
}
